@extends('layouts.app')
@section('title', __('lang_v1.stock_transfers'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header no-print">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">Intercompany Sales
    </h1>
</section>

<!-- Main content -->
<section class="content no-print">
    @component('components.widget', ['class' => 'box-primary', 'title' => __('lang_v1.all_stock_transfers')])
        @slot('tool')
            <div class="box-tools">
                @if(auth()->user()->can('purchase.create'))
                    <a class="tw-dw-btn tw-bg-gradient-to-r tw-from-indigo-600 tw-to-blue-500 tw-font-bold tw-text-white tw-border-none tw-rounded-full pull-right"
                        href="{{action([\App\Http\Controllers\StockTransferController::class, 'create'])}}">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor"
                            stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                            class="icon icon-tabler icons-tabler-outline icon-tabler-plus">
                            <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                            <path d="M12 5l0 14" />
                            <path d="M5 12l14 0" />
                        </svg> @lang('messages.add')
                    </a>
                @endif
            </div>
        @endslot
        <div class="table-responsive">
            <table class="table table-bordered table-striped ajax_view" id="stock_transfer_table">
                <thead>
                    <tr>
                        <th>@lang('messages.date')</th>
                        <th>@lang('purchase.ref_no')</th>
                        <th>@lang('lang_v1.location_from')</th>
                        <th>@lang('lang_v1.location_to')</th>
                        <th>@lang('sale.status')</th>
                        <th>@lang('lang_v1.shipping_charges')</th>
                        <th>@lang('stock_adjustment.total_amount')</th>
                        <th>@lang('purchase.additional_notes')</th>
                        <th>@lang('messages.action')</th>
                    </tr>
                </thead>
                <tfoot>
                    <tr>
                        <th colspan="5" style="text-align:right">Total:</th>
                        <th id="shipping-total"></th>
                        <th id="final-total"></th>
                        <th colspan="2"></th>
                    </tr>
                </tfoot>
            </table>
        </div>
    @endcomponent
</section>

@include('stock_transfer.partials.update_status_modal')

<section id="receipt_section" class="print_section"></section>

<!-- /.content -->
@stop

@section('javascript')
<script>
$(document).ready(function() {
    // Initialize DataTable
    var stock_transfer_table = $('#stock_transfer_table').DataTable({
        processing: true,
        serverSide: true,
        aaSorting: [[0, 'desc']],
        ajax: {
            url: '/stock-transfers',
            data: function(d) {
                d.include_totals = true;
            }
        },
        columns: [
            { data: 'transaction_date', name: 'transaction_date' },
            { data: 'ref_no', name: 'ref_no' },
            { data: 'location_from', name: 'l1.name' },
            { data: 'location_to', name: 'l2.name' },
            { data: 'status', name: 'status' },
            { 
                data: 'shipping_charges', 
                name: 'shipping_charges',
                render: function(data, type, row) {
                    if (type === 'display') {
                        return data;
                    }
                    // For sorting/filtering, extract the numeric value
                    return parseFloat($(data).text()) || 0;
                }
            },
            { 
                data: 'final_total', 
                name: 'final_total',
                render: function(data, type, row) {
                    if (type === 'display') {
                        return data;
                    }
                    return parseFloat($(data).text()) || 0;
                }
            },
            { data: 'additional_notes', name: 'additional_notes' },
            { data: 'action', name: 'action', orderable: false, searchable: false }
        ],
        drawCallback: function(settings) {
            // Apply currency formatting
            __currency_convert_recursively($('#stock_transfer_table'));
            
            // Update totals from server response
            var json = stock_transfer_table.ajax.json();
            if (json && json.summary) {
                $('#shipping-total').html('<span class="display_currency" data-currency_symbol="true">' + json.summary.shipping_charges_sum + '</span>');
                $('#final-total').html('<span class="display_currency" data-currency_symbol="true">' + json.summary.final_total_sum + '</span>');
                __currency_convert_recursively($('#stock_transfer_table tfoot'));
            }
        },
        initComplete: function() {
            // Initialize currency formatting
            __currency_convert_recursively($('#stock_transfer_table'));
        }
    });
});
</script>
@endsection

@cannot('view_purchase_price')
    <style>
        .show_price_with_permission {
            display: none !important;
        }
    </style>
@endcannot